<?php
/**
 * Plugin Name: Human Logica Functional
 * Plugin URI: https://creartheme.com
 * Author: Aditya Candra Setiawan
 * Description: A plugin to add human logic functionalities.
 * Version: 1.0
 * Author URI: https://creartheme.com
 */
 
// Direct access not allowed
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'HUMANLOGICA_DIR', plugin_dir_path( __FILE__ ) );
define( 'HUMANLOGICA_URL', plugin_dir_url( __FILE__ ) );

add_action( 'wp_enqueue_scripts', 'humanlogica_enqueue_scripts' );
function humanlogica_enqueue_scripts() {
    wp_enqueue_script('jquery');
    wp_enqueue_script( 'humanlogica-js', HUMANLOGICA_URL . 'assets/js/humanlogica.js', array( 'jquery' ), '1.0', true );
    wp_enqueue_script( 'owlcarousel-js', HUMANLOGICA_URL . 'assets/lib/owl-carousel/owl.carousel.min.js', array( 'jquery' ), '1.0', true );
    
    wp_enqueue_style( 'humanlogica-css', HUMANLOGICA_URL . 'assets/css/humanlogica.css', array(), '1.0' );
    wp_enqueue_style( 'owlcarousel-css', HUMANLOGICA_URL . 'assets/lib/owl-carousel/owl.carousel.min.css', array(), '1.0' );
}

function increment_page_views($post_id) {
    // Abaikan untuk halaman admin atau jika $post_id tidak valid
    if (is_admin() || empty($post_id)) {
        return;
    }

    // Periksa apakah metadata 'page_views' sudah ada
    $views = get_post_meta($post_id, 'page_views', true);

    // Jika belum ada, set menjadi 1, jika sudah ada, tambahkan 1
    $views = $views ? intval($views) + 1 : 1;

    // Simpan metadata
    update_post_meta($post_id, 'page_views', $views);
}

add_action('wp_head', function() {
    if (is_singular('events')) {
        increment_page_views(get_the_ID());
    }
});

require_once HUMANLOGICA_DIR . 'inc/humanlogica-shortcode.php';

