jQuery(document).ready(function($) {
    $('.faq-question').click(function() {
        var index = $(this).data('index');
        var answer = $(this).next('.faq-answer');
        var icon = $(this).find('.faq-icon');

        if (answer.is(':visible')) {
            answer.slideUp();
            icon.text('+');
        } else {
            $('.faq-answer').slideUp();
            $('.faq-icon').text('+');
            answer.slideDown();
            icon.text('-');
        }
    });

    $('.clients-carousel').owlCarousel({
        loop:true,
        margin:15,
        responsiveClass:true,
        autoplay:true,
        autoplayTimeout:3000,
        autoplayHoverPause:true,
        nav:false,
        autoWidth: true,
        responsive:{
            0:{
                items:2,
            },
            600:{
                items:3,
            },
            1000:{
                items:5,
            }
        }
    })
});